/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class VWFileURLDialog
extends VWModalDialog
implements ActionListener,
KeyListener {
    private int m_nExitResult = -1;
    private JButton m_cancelButton = null;
    private JButton m_okButton = null;
    private JButton m_helpButton = null;
    private JRadioButton m_UNCRadioButton = null;
    private JRadioButton m_URLRadioButton = null;
    private JTextField m_UNCTextField = null;
    private JTextField m_URLTextField = null;
    private JButton m_browseButton = null;
    private FileDialog m_openFileDialog = null;
    private String m_selectedFile = null;
    private Frame m_parentFrame = null;
    private Dialog m_parentDialog = null;
    private Color m_enabledBkgrndColor = SystemColor.text;

    public VWFileURLDialog(Frame parent) {
        super(parent);
        try {
            this.m_parentFrame = parent;
            this.init();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWFileURLDialog(Dialog parent) {
        super(parent);
        try {
            this.m_parentDialog = parent;
            this.init();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getSelectedFile() {
        return this.m_selectedFile;
    }

    public int showDialog(Container parent) throws VWException {
        this.show();
        return this.m_nExitResult;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_okButton) {
            this.onOK();
        } else if (object == this.m_cancelButton) {
            this.onCancel();
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_General + "bpfwd052.htm");
        } else if (object == this.m_UNCRadioButton || object == this.m_URLRadioButton) {
            this.enableDisableTextControls();
            this.setOKButtonState();
        } else if (object == this.m_browseButton) {
            this.onBrowse();
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        this.setOKButtonState();
    }

    private void init() {
        Dimension dim = VWStringUtils.stringToDimension("475, 195");
        if (dim == null) {
            dim = new Dimension(430, 175);
        }
        this.setSize(dim);
        this.setTitle(VWResource.s_selectAttachmentType);
        this.setVisible(false);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.getContentPane().add((Component)this.getURLPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonControlPanel(), "Last");
        this.m_okButton.addActionListener(this);
        this.m_cancelButton.addActionListener(this);
        this.m_helpButton.addActionListener(this);
        this.m_browseButton.addActionListener(this);
        this.m_URLRadioButton.addActionListener(this);
        this.m_UNCRadioButton.addActionListener(this);
        this.m_URLTextField.addKeyListener(this);
        this.m_UNCTextField.addKeyListener(this);
        this.m_URLRadioButton.setSelected(false);
        this.m_UNCRadioButton.setSelected(true);
        this.enableDisableTextControls();
        this.setOKButtonState();
        if (this.m_parentFrame != null) {
            this.m_openFileDialog = new FileDialog(this.m_parentFrame);
        } else if (this.m_parentDialog != null) {
            this.m_openFileDialog = new FileDialog((Frame)this.m_parentDialog.getParent());
        }
        this.m_openFileDialog.setMode(0);
        this.m_openFileDialog.setTitle(VWResource.s_open);
    }

    private JPanel getURLPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            ButtonGroup grp = new ButtonGroup();
            this.m_UNCRadioButton = new JRadioButton(VWResource.s_UNC);
            this.m_URLRadioButton = new JRadioButton(VWResource.s_URL);
            grp.add(this.m_UNCRadioButton);
            grp.add(this.m_URLRadioButton);
            this.m_browseButton = new JButton(VWResource.s_browseDots);
            this.m_UNCTextField = new JTextField();
            this.m_enabledBkgrndColor = this.m_UNCTextField.getBackground();
            this.m_URLTextField = new JTextField();
            int nRow = 0;
            gbCons.insets = new Insets(10, 5, 0, 5);
            this.addRowControls(this.m_UNCRadioButton, this.m_UNCTextField, this.m_browseButton, nRow, panel, gbCons);
            gbCons.insets = new Insets(0, 5, 0, 5);
            this.addRowControls(new JLabel(), new JLabel(VWResource.s_UNCExample), new JLabel(), ++nRow, panel, gbCons);
            gbCons.insets = new Insets(15, 5, 0, 5);
            this.addRowControls(this.m_URLRadioButton, this.m_URLTextField, new JLabel(), ++nRow, panel, gbCons);
            gbCons.insets = new Insets(0, 5, 15, 5);
            this.addRowControls(new JLabel(), new JLabel(VWResource.s_URLExample), new JLabel(), ++nRow, panel, gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void addRowControls(Component comp1, Component comp2, Component comp3, int nRow, JPanel panel, GridBagConstraints gbCons) {
        try {
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = nRow;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            panel.add(comp1, gbCons);
            gbCons.gridwidth = 3;
            gbCons.gridx = 1;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            panel.add(comp2, gbCons);
            gbCons.gridwidth = -1;
            gbCons.gridx = 4;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            panel.add(comp3, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getButtonControlPanel() {
        try {
            JPanel panel = new JPanel(new FlowLayout());
            if (this.m_okButton == null) {
                this.m_okButton = new JButton(VWResource.s_ok);
                this.m_okButton.setSelected(true);
            }
            panel.add(this.m_okButton);
            if (this.m_cancelButton == null) {
                this.m_cancelButton = new JButton(VWResource.s_cancel);
            }
            panel.add(this.m_cancelButton);
            if (this.m_helpButton == null) {
                this.m_helpButton = new JButton(VWResource.s_help);
            }
            panel.add(this.m_helpButton);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void onOK() {
        boolean bSetVisible = false;
        URL specifiedURL = null;
        this.m_nExitResult = 0;
        if (this.m_UNCRadioButton.isSelected()) {
            if (this.m_UNCTextField != null) {
                specifiedURL = this.getURL(this.m_UNCTextField.getText(), VWResource.s_invalidUNCFormat);
                if (specifiedURL != null) {
                    String specifiedFile = specifiedURL.toString();
                    if (!specifiedFile.startsWith("file://")) {
                        int nResult = VWMessageDialog.showConfirmDialog(this, VWResource.s_confirmLocalFile);
                        switch (nResult) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                specifiedURL = null;
                                bSetVisible = true;
                                break;
                            }
                            case 4: {
                                this.onCancel();
                                return;
                            }
                        }
                    }
                } else {
                    specifiedURL = null;
                    bSetVisible = true;
                }
            }
        } else if (this.m_URLRadioButton.isSelected()) {
            if (this.m_URLTextField != null && (specifiedURL = this.getURL(this.m_URLTextField.getText(), VWResource.s_invalidURLFormat)) == null) {
                bSetVisible = true;
            }
            if (specifiedURL != null && !this.isValidConnection(specifiedURL)) {
                int nResult2 = VWMessageDialog.showConfirmDialog(this, VWResource.s_confirmNonConnectedFile);
                switch (nResult2) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        specifiedURL = null;
                        bSetVisible = true;
                        break;
                    }
                    case 4: {
                        this.onCancel();
                        return;
                    }
                }
            }
        }
        if (specifiedURL != null) {
            this.m_selectedFile = specifiedURL.toString();
        }
        this.setVisible(bSetVisible);
    }

    private void onBrowse() {
        try {
            this.m_openFileDialog.setVisible(true);
            String fileToOpen = this.m_openFileDialog.getFile();
            if (fileToOpen != null) {
                File file = new File(this.m_openFileDialog.getDirectory() + fileToOpen);
                if (this.m_UNCRadioButton.isSelected()) {
                    this.m_UNCTextField.setText(file.toURL().toString());
                }
            }
            this.setOKButtonState();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onCancel() {
        this.m_selectedFile = null;
        this.m_nExitResult = 1;
        this.setVisible(false);
    }

    private void enableTextControl(JTextField field) {
        field.setEnabled(true);
        field.setBackground(this.m_enabledBkgrndColor);
    }

    private void disableTextControl(JTextField field) {
        field.setText("");
        field.setBackground(this.getBackground());
        field.setEnabled(false);
    }

    private void enableDisableTextControls() {
        if (this.m_UNCRadioButton.isSelected()) {
            this.enableTextControl(this.m_UNCTextField);
            this.disableTextControl(this.m_URLTextField);
            this.m_browseButton.setEnabled(true);
        } else if (this.m_URLRadioButton.isSelected()) {
            this.enableTextControl(this.m_URLTextField);
            this.disableTextControl(this.m_UNCTextField);
            this.m_browseButton.setEnabled(false);
        }
    }

    private void setOKButtonState() {
        boolean bEnable = true;
        String file = null;
        if (this.m_UNCRadioButton.isSelected()) {
            file = this.m_UNCTextField.getText();
            if (file == null || VWStringUtils.compare(file, "") == 0) {
                bEnable = false;
            }
        } else if (this.m_URLRadioButton.isSelected()) {
            file = this.m_URLTextField.getText();
            if (file == null || VWStringUtils.compare(file, "") == 0) {
                bEnable = false;
            }
        } else {
            bEnable = false;
        }
        this.m_okButton.setEnabled(bEnable);
    }

    private URL getURL(String fileName, String message) {
        try {
            return new URL(fileName);
        }
        catch (MalformedURLException ex) {
            VWMessageDialog.showOptionDialog(this, message, VWResource.s_error, 0);
            return null;
        }
    }

    private boolean isValidConnection(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }
}

